/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.io.File;
import java.io.FileFilter;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;

public class ClassCache
implements RevisionHandler {
    public static final boolean VERBOSE = false;
    public static final String DEFAULT_PACKAGE = "DEFAULT";
    protected Hashtable<String, HashSet<String>> m_Cache;

    public ClassCache() {
        this.initialize();
    }

    protected String cleanUp(String classname) {
        String result = classname;
        if (result.indexOf("/") > -1) {
            result = result.replace("/", ".");
        }
        if (result.indexOf("\\") > -1) {
            result = result.replace("\\", ".");
        }
        if (result.endsWith(".class")) {
            result = result.substring(0, result.length() - 6);
        }
        return result;
    }

    protected String extractPackage(String classname) {
        if (classname.indexOf(".") > -1) {
            return classname.substring(0, classname.lastIndexOf("."));
        }
        return DEFAULT_PACKAGE;
    }

    public boolean add(String classname) {
        String pkgname = this.extractPackage(classname = this.cleanUp(classname));
        if (!this.m_Cache.containsKey(pkgname)) {
            this.m_Cache.put(pkgname, new HashSet());
        }
        HashSet<String> names = this.m_Cache.get(pkgname);
        return names.add(classname);
    }

    public boolean remove(String classname) {
        String pkgname = this.extractPackage(classname = this.cleanUp(classname));
        HashSet<String> names = this.m_Cache.get(pkgname);
        if (names != null) {
            return names.remove(classname);
        }
        return false;
    }

    protected void initFromDir(String prefix, File dir) {
        File file;
        File[] files;
        File[] fileArray = files = dir.listFiles(new ClassFileFilter());
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            file = fileArray[n2];
            if (prefix == null) {
                this.add(file.getName());
            } else {
                this.add(String.valueOf(prefix) + "." + file.getName());
            }
            ++n2;
        }
        fileArray = files = dir.listFiles(new DirectoryFilter());
        n = files.length;
        n2 = 0;
        while (n2 < n) {
            file = fileArray[n2];
            if (prefix == null) {
                this.initFromDir(file.getName(), file);
            } else {
                this.initFromDir(String.valueOf(prefix) + "." + file.getName(), file);
            }
            ++n2;
        }
    }

    protected void initFromDir(File dir) {
        this.initFromDir(null, dir);
    }

    protected void initFromJar(File file) {
        if (!file.exists()) {
            System.out.println("Jar does not exist: " + file);
            return;
        }
        try {
            JarFile jar = new JarFile(file);
            Enumeration<JarEntry> enm = jar.entries();
            while (enm.hasMoreElements()) {
                JarEntry entry = enm.nextElement();
                if (!entry.getName().endsWith(".class")) continue;
                this.add(entry.getName());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Enumeration<String> packages() {
        return this.m_Cache.keys();
    }

    public HashSet<String> getClassnames(String pkgname) {
        if (this.m_Cache.containsKey(pkgname)) {
            return this.m_Cache.get(pkgname);
        }
        return new HashSet<String>();
    }

    protected void initialize() {
        URL[] urls;
        this.m_Cache = new Hashtable();
        URLClassLoader sysLoader = (URLClassLoader)this.getClass().getClassLoader();
        URL[] uRLArray = urls = sysLoader.getURLs();
        int n = urls.length;
        int n2 = 0;
        while (n2 < n) {
            URL url = uRLArray[n2];
            File file = null;
            String part = url.toString();
            if (part.startsWith("file:")) {
                part = part.replace(" ", "%20");
                try {
                    file = new File(new URI(part));
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
            } else {
                file = new File(part);
            }
            if (file == null) {
                System.err.println("Skipping: " + part);
            } else if (file.isDirectory()) {
                this.initFromDir(file);
            } else if (file.exists()) {
                this.initFromJar(file);
            }
            ++n2;
        }
    }

    public ArrayList<String> find(String matchText) {
        ArrayList<String> result = new ArrayList<String>();
        Enumeration<String> packages = this.m_Cache.keys();
        while (packages.hasMoreElements()) {
            for (String name : this.m_Cache.get(packages.nextElement())) {
                if (!name.contains(matchText)) continue;
                result.add(name);
            }
        }
        if (result.size() > 1) {
            Collections.sort(result);
        }
        return result;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8034 $");
    }

    public static void main(String[] args) {
        ClassCache cache = new ClassCache();
        Enumeration<String> packages = cache.packages();
        while (packages.hasMoreElements()) {
            String key = packages.nextElement();
            System.out.println(String.valueOf(key) + ": " + cache.getClassnames(key).size());
        }
    }

    public static class ClassFileFilter
    implements FileFilter {
        @Override
        public boolean accept(File pathname) {
            return pathname.getName().endsWith(".class");
        }
    }

    public static class DirectoryFilter
    implements FileFilter {
        @Override
        public boolean accept(File pathname) {
            return pathname.isDirectory();
        }
    }
}

